import * as types from './mutation-types'
import {
  ScheduleResource,
  GuestResource,
  CandidateResource,
  ExportResource,
  SystemLogResource
} from '../resources'

export const bootstrap = ({dispatch}, data) => {
  if (data.school_id) {
    dispatch(types.VIEW, ['grid', 'list'][+!!data.school_id])
  }

  dispatch(types.SCHOOL_ID          , data.school_id)
  dispatch(types.MEETING            , data.meeting)
  dispatch(types.MEETINGS           , data.meetings)
  dispatch(types.SCHOOLS            , data.schools)
  dispatch(types.SCHEDULE           , data.schedule)
  dispatch(types.SCHEDULE_SLOTS     , data.scheduleSlots)
  dispatch(types.SCHEDULE_GUESTS    , data.schedule_guests)
  dispatch(types.CANDIDATES         , data.candidates)
  dispatch(types.GUESTS             , data.guests)
  dispatch(types.RESERVE            , data.reserve)
  dispatch(types.COUNTRIES          , data.countries)

  dispatch(types.MAP_SCHEDULE_SLOTS , data.mapScheduleSlots)
  dispatch(types.MAP_GUEST_SLOT     , data.mapGuestSlot)
  dispatch(types.MAP_GUEST_SCHOOL   , data.mapGuestSchool)
}

export const setServerSync = ({ dispatch }, val) => {
  dispatch(types.SERVER_SYNC, val)
}

export const setDev = ({ dispatch }, val) => {
  localStorage.dev = !!val
  dispatch(types.DEV, !!val)
}

export const setMeeting = ({ dispatch }, meeting) => {
  // ScheduleResource.get({ meeting.id })
  //   .then(() => {
  //
  //   })
  dispatch(types.MEETING, meeting)
}

function update(dispatch, type, oldData, newData, opts = {}) {
  let ignore = opts.ignore || []

  for (let [id, data] of Object.entries(newData)) {
    if (ignore.find(i => i == id)) {
      console.log('update ignore', type, data)
      continue
    }

    for (let [key, val] of Object.entries(data)) {
      if (!oldData[id]) {
        dispatch(type, id, data)

        console.log('update not found old', type, id)
        continue
      }

      let prev = oldData[id][key],
          next = val

      if (prev !== null && typeof(prev) == 'object') {
        prev = (Object.values(prev)).join()
      }

      if (next !== null && typeof(next) == 'object') {
        next = (Object.values(next)).join()
      }

      if (prev != next) {
        dispatch(type, id, data)
        continue
      }
    }
  }
}

function mapSync(dispatch, type, oldData, newData) {
  for (let [id, data] of Object.entries(oldData)) {
    if (id && data && !newData[id]) {
      console.log('mapSync rm ', id, data)
      dispatch(type, id, null)
    }
  }

  for (let [id, data] of Object.entries(newData)) {
    if (!oldData[id]) {
      console.log('ADD ', type, data);
      dispatch(type, id, data)
      continue
    }

    let prev = oldData[id],
        next = data

    if (prev != null && typeof(prev) == 'object') {
      prev = prev.join()
    }

    if (next != null && typeof(next) == 'object') {
      next = next.join()
    }

    if (prev != next) {
      console.log('UPDATE ', type, prev, next);
      dispatch(type, id, data)
    }
  }
}

export const syncMapScheduleSlots = ({ dispatch }, oldData, newData) => {
  mapSync(dispatch, types.UPDATE_MAP_SCHEDULE_SLOTS, oldData, newData)
}

export const syncMapGuestSlot = ({ dispatch }, oldData, newData) => {
  mapSync(dispatch, types.UPDATE_MAP_GUEST_SLOT, oldData, newData)
}

export const updateMapGuestSlot = ({ dispatch }, id, data) => {
  dispatch(types.UPDATE_MAP_GUEST_SLOT, id, data)
}


export const syncMapGuestSchool = ({ dispatch }, oldData, newData) => {
  mapSync(dispatch, types.UPDATE_MAP_GUEST_SCHOOL, oldData, newData)
}

export const updateMapGuestSchool = ({ dispatch }, id, data) => {
  dispatch(types.UPDATE_MAP_GUEST_SCHOOL, id, data)
}


export const updateSchools = ({ dispatch }, oldData, newData) => {
  if (!Object.keys(oldData).length) return dispatch(types.SCHOOLS, newData)

  update(dispatch, types.UPDATE_SCHOOL, oldData, newData)
}

export const updateGuests = ({ dispatch }, oldData, newData) => {
  if (!Object.keys(oldData).length && Object.keys(newData).length) return dispatch(types.GUESTS, newData)

  update(dispatch, types.UPDATE_GUEST, oldData, newData)
}

export const addReserve = ({ dispatch }, schoolId, data) => {
  dispatch(types.ADD_RESERVE, schoolId, data)
}

export const updateReserve = ({ dispatch }, oldData, newData) => {
  // if (JSON.stringify(oldData) != JSON.stringify(newData))

  if (Object.keys(newData).length != Object.keys(oldData).length) {
    console.log('updateReserve', 'all update', newData, Object.keys(newData), Object.keys(oldData))
    return dispatch(types.RESERVE, !Object.keys(newData).length ? {} : newData)
  }

  // remove data
  for (let [schoolId, oldReserves] of Object.entries(oldData)) {
    if (schoolId && !newData[schoolId]) {
      console.log('updateReserve', 'clear schools reverses', schoolId)
      dispatch(types.UPDATE_RESERVE, schoolId, [])
      continue
    }

    // for (let oldReserve of oldReserves) {
      // if (newData[schoolId])
    // }
  }

  for (let [schoolId, newReserves] of Object.entries(newData)) {
    if (!oldData[schoolId] || (oldData[schoolId].length != newReserves.length)) {
      console.log('updateReserve', 'update schools reverses', schoolId)
      dispatch(types.UPDATE_RESERVE, schoolId, newData[schoolId])
      continue
    }
  }

  // console.info(oldData, oldData.length)
  /*if (Object.keys(oldData).length && Object.keys(newData).length) {
    for (let [schoolId, oldReserves] of Object.entries(oldData)) {
      if ((undefined !== oldReserves && oldReserves.length) != newData[schoolId].length) {
        dispatch(types.UPDATE_RESERVE, schoolId, newData[schoolId])
        continue
      }
    }
  } else {
    dispatch(types.RESERVE, newData)
  }*/
}

export const deleteReserve = ({ dispatch }, schoolId, reserve) => {
  dispatch(types.DELETE_RESERVE, schoolId, reserve)
}

export const updateCandidates = ({ dispatch }, oldData, newData, editableCandidateId = null) => {
  if (!Object.keys(oldData).length && Object.keys(newData).length) return dispatch(types.CANDIDATES, newData)

  update(dispatch, types.UPDATE_CANDIDATE, oldData, newData, {
    ignore: [editableCandidateId]
  })
}

export const getCandidateProfile = ({ dispatch }, id) => {
  return CandidateResource.get({ id })
    .then(res => {
      dispatch(types.UPDATE_CANDIDATE, id, res.data)
    })
}

export const editCandidateProfile = ({ dispatch }, id) => {
  dispatch(types.EDITABLE_CANDIDATE_ID, id)
}

export const movableCandidateData = ({ dispatch }, data) => {
  dispatch(types.MOVABLE_CANDIDATE_DATA, data)
}

export const saveCandidateProfile = ({ dispatch }, id, data) => {
  if (!id) {
    return CandidateResource.save({ 'Candidate': data })
      .then(res => {
        dispatch(types.UPDATE_CANDIDATE, res.data.candidate.id, res.data.candidate)

        return res.data
      })
  }

  return CandidateResource.update({ id }, data)
    .then(res => {
      dispatch(types.UPDATE_CANDIDATE, id, data)
    })
}

export const updateGuest = ({ dispatch }, id, data) => {
  dispatch(types.UPDATE_GUEST, id, data)
}

export const updateScheduleGuests = ({ dispatch }, oldData, newData, schedule) => {
  if (!Object.keys(oldData).length) {
    return dispatch(types.SCHEDULE_GUESTS , newData)
  }

  for (let [schoolId, newItem] of Object.entries(newData)) {
    for (let slot of Object.values(schedule)) {
      let oldGuests = (oldData[schoolId] || [])[slot.key] || []
      let newGuests = newItem[slot.key] || []

      if (newGuests.join() != oldGuests.join()) {
        dispatch(types.SCHEDULE_GUEST, schoolId, slot.key, newGuests)
      }
    }
  }
}

export const updateSchedule = ({ dispatch }, schedule) => {
  dispatch(types.SCHEDULE, schedule)
}

export const updateCurrentSchool = ({dispatch}, schoolId) => {
  dispatch(types.SCHOOL_ID, schoolId)
}

export const changeView = ({ dispatch }, view) => {
  dispatch(types.VIEW, view)
}

export const addGuest = ({dispatch}, data) => {
  return GuestResource.save({ 'Guest': data })
    .then(res => {
      console.log('dispatch guest', res)
      dispatch(types.UPDATE_GUEST, res.data.guest.id, res.data.guest)

      return res.data
    })
}

export const patchGuest = ({dispatch}, id, data) => {
  return GuestResource.update({ id }, data)
    .then(res => {
      dispatch(types.PATCH_GUEST, id, data)
    })
}

export const getDataForExport = ({ dispatch }, data) => {
  ExportResource.get()
    .then(res => {
      dispatch(types.DATA_FOR_EXPORT, res.data)
    })
}

export const getSystemLogs = ({ dispatch }, filter) => {
  SystemLogResource.get({ filter: JSON.stringify(filter) })
    .then(res => {
      dispatch(types.SYSTEM_LOGS, res.data)
    })
}

export const getSystemLogUsers = ({ dispatch }, query = '') => {
  SystemLogResource.get({ action: 'users', query: query })
    .then(res => {
      dispatch(types.SYSTEM_LOG_USERS, res.data)
    })
}
