import * as types from './mutation-types'

export default {
  [types.SERVER_SYNC](state, val) {
    state.serverSync = val
  },

  [types.DEV](state, val) {
    state.dev = val
  },

  [types.VIEW](state, view) {
    state.view = view
  },

  [types.SCHOOLS](state, schools) {
    if (Array.isArray(schools) && !schools.length) {
      state.schools = {}
      return
    }

    state.schools = schools
  },

  [types.UPDATE_SCHOOL](state, id, data) {
    if (data) {
      state.schools[id] = data
    }
  },

  [types.SCHOOL_ID](state, schoolId) {
    state.schoolId = schoolId
  },

  [types.MEETING](state, meeting) {
    if (meeting) {
      state.meeting = meeting
    }
  },

  [types.MEETINGS](state, meetings) {
    if (meetings) {
      state.meetings = meetings
    }
  },

  [types.SCHEDULE](state, schedule) {
    if (Array.isArray(schedule) && !schedule.length) {
      state.schedule = {}
      return
    }

    state.schedule = schedule
  },

  [types.SCHEDULE_SLOTS](state, scheduleSlots) {
    if (Array.isArray(scheduleSlots) && !scheduleSlots.length) {
      state.scheduleSlots = {}
      return
    }

    state.scheduleSlots = scheduleSlots
  },

  [types.SCHEDULE_GUESTS](state, scheduleGuests) {
    if (Array.isArray(scheduleGuests) && !scheduleGuests.length) {
      state.scheduleGuests = {}
      return
    }

    state.scheduleGuests = scheduleGuests
  },

  [types.SCHEDULE_GUEST](state, schoolId, scheduleId, guests) {
    if (schoolId && cheduleId && guests) {
      state.scheduleGuests[schoolId][scheduleId] = guests
    }
  },


  [types.CANDIDATES](state, candidates) {
    if (Array.isArray(candidates) && !candidates.length) {
      state.candidates = {}
      return
    }

    state.candidates = candidates
  },

  [types.UPDATE_CANDIDATE](state, id, data) {
    if (data.country_id) {
      data.country = state.countries.find(c => c.id == data.country_id)
    }

    state.candidates[id] = data
  },

  [types.CANDIDATE_PROFILE](state, id, profile) {
    state.candidates[id].profile = profile
  },

  [types.EDITABLE_CANDIDATE_ID](state, id) {
    state.editableCandidateId = id
  },

  [types.MOVABLE_CANDIDATE_DATA](state, data) {
    state.movableCandidateData = data
  },


  [types.GUESTS](state, guests) {
    if (Array.isArray(guests) && !guests.length) {
      state.guests = {}
      return
    }

    state.guests = guests
  },

  [types.UPDATE_GUEST](state, id, data) {
    state.guests[id] = data
  },

  [types.PATCH_GUEST](state, id, data) {
    for (let [key, val] of Object.entries(data)) {
      state.guests[id][key] = val
    }
  },

  [types.RESERVE](state, data) {
    if (Array.isArray(data) && !data.length) {
      state.reserve = {}
      return
    }

    state.reserve = data
  },

  [types.ADD_RESERVE](state, schoolId, data) {
    if (!state.reserve[schoolId]) {
      state.reserve[schoolId] = []
    }

    state.reserve[schoolId].push(data)
  },

  [types.UPDATE_RESERVE](state, schoolId, data) {
    state.reserve[schoolId] = data
  },

  [types.DELETE_RESERVE](state, schoolId, reserve) {
    state.reserve[schoolId].$remove(reserve)
  },


  [types.COUNTRIES](state, data) {
    if (data) {
      state.countries = data
    }
  },


  [types.MAP_SCHEDULE_SLOTS](state, data) {
    if (Array.isArray(data) && !data.length) {
      state.mapScheduleSlots = {}
      return
    }

    state.mapScheduleSlots = data
  },

  [types.MAP_GUEST_SLOT](state, data) {
    if (Array.isArray(data) && !data.length) {
      state.mapGuestSlot = {}
      return
    }

    state.mapGuestSlot = data
  },

  [types.MAP_GUEST_SCHOOL](state, data) {
    if (Array.isArray(data) && !data.length) {
      state.mapGuestSchool = {}
      return
    }

    state.mapGuestSchool = data
  },

  [types.UPDATE_MAP_SCHEDULE_SLOTS](state, id, data) {
    if (data == 'delete') {
      delete state.mapScheduleSlots[id]
    } else {
      state.mapScheduleSlots[id] = data
    }
  },

  [types.UPDATE_MAP_GUEST_SLOT](state, id, data) {
    if (data == 'delete') {
      state.mapGuestSlot[id] = null
    } else {
      state.mapGuestSlot[id] = data
    }
  },

  [types.UPDATE_MAP_GUEST_SCHOOL](state, id, data) {
    if (data == 'delete') {
      delete state.mapGuestSchool[id]
    } else {
      state.mapGuestSchool[id] = data
    }
  },

  [types.DATA_FOR_EXPORT](state, data) {
    state.dataForExport = data
  },

  [types.SYSTEM_LOGS](state, data) {
    state.systemLog.logs = data
  },

  [types.SYSTEM_LOG_USERS](state, data) {
    state.systemLog.users = data
  },
}
