export default () => {
  $.fn.DataTable.ext.renderer.pageButton.bootstrap = function ( settings, host, idx, buttons, page, pages ) {
  	var api     = new $.fn.DataTable.Api( settings );
  	var classes = settings.oClasses;
  	var lang    = settings.oLanguage.oPaginate;
  	var aria = settings.oLanguage.oAria.paginate || {};
  	var btnDisplay, btnClass, counter=0;

  	var attach = function( container, buttons ) {
  		var i, ien, node, button;
  		var clickHandler = function ( e ) {
  			e.preventDefault();
  			if ( !$(e.currentTarget).hasClass('disabled') && api.page() != e.data.action ) {
  				api.page( e.data.action ).draw( 'page' );
  			}
  		};

  		for ( i=0, ien=buttons.length ; i<ien ; i++ ) {
  			button = buttons[i];

  			if ( $.isArray( button ) ) {
  				attach( container, button );
  			}
  			else {
          btnDisplay = button;
          btnClass = page === counter ?
            'active' : '';

  				if ( btnDisplay ) {
  					node = $('<li>', {
  							'class': classes.sPageButton+' '+btnClass,
  							'id': null
  						} )
  						.append( $('<a>', {
  								'href': '#',
  								'aria-controls': settings.sTableId,
  								'aria-label': aria[ button ],
  								'data-dt-idx': counter,
  								'tabindex': settings.iTabIndex,
  								'class': 'page-link'
  							} )
  							.html( btnDisplay )
  						)
  						.appendTo( container );

  					settings.oApi._fnBindAction(
  						node, {action: counter}, clickHandler
  					);

  					counter++;
  				}
  			}
  		}
  	};

  	// IE9 throws an 'unknown error' if document.activeElement is used
  	// inside an iframe or frame.
  	var activeEl;

  	try {
  		// Because this approach is destroying and recreating the paging
  		// elements, focus is lost on the select button which is bad for
  		// accessibility. So we want to restore focus once the draw has
  		// completed
  		activeEl = $(host).find(document.activeElement).data('dt-idx');
  	}
  	catch (e) {}

  	attach(
  		$(host).empty().html('<ul class="pagination"/>').children('ul'),
  		buttons
  	);

  	if ( activeEl ) {
  		$(host).find( '[data-dt-idx='+activeEl+']' ).focus();
  	}
  };
}
