import Vue from 'vue'
import VueRouter from 'vue-router'
import app from './app'
import routes from './routes'
import store from './vuex/store'
import {
  bootstrap,
} from './vuex/actions'

Vue.use(VueRouter)

Vue.transition('fade', {
  css: false,
  enter: function (el, done) {
    $(el)
      .css('opacity', 0)
      .animate({ opacity: 1 }, 500, done)
  },
  enterCancelled: function (el) {
    $(el).stop()
  },
  leave: function (el, done) {
    $(el).animate({ opacity: 0 }, 500, done)
  },
  leaveCancelled: function (el) {
    $(el).stop()
  }
})

Vue.mixin({
  computed: {
    permissions() {
      return this.$root.user.permissions
    },

    role() {
      return this.$root.user.role
    }
  }
})

Vue.http.interceptors.push((request, next) => {
    next((res) => {
      // session timeout
      if (res.status == 403) {
        window.location = '/'
      }
    })
})

const router = new VueRouter({
  hashbang: false,
  history: true,
  mode: 'html5',
  root: '/',
  linkActiveClass: 'active'
})
router.mode = 'html5'
router.map(routes)

document.addEventListener('DOMContentLoaded', () => {
  if (window.bootstrapData) {
    bootstrap(store, window.bootstrapData)
  }

  router.start(app, '#app')
})
