import Vue from 'vue'
import Vuex from 'vuex'
import mutations from './mutations'
import createLogger from 'vuex/logger'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    serverSync           : true,
    dev                  : localStorage.dev == "true",

    view                 : 'grid',

    meetingId            : null,
    schoolId             : null,
    meetings             : [],
    schools              : {},
    schedule             : {},
    scheduleSlots        : {},
    scheduleGuests       : {},
    candidates           : {},
    guests               : {},
    reserve              : {},
    countries            : [],

    mapScheduleSlots     : {},
    mapGuestSlot         : {},
    mapGuestSchool       : {},

    editableCandidateId  : null,
    movableCandidateData : {},

    dataForExport        : {},

    systemLog            : {
      logs: [],
      users: [],
    }
  },
  mutations,
  plugins: process.env.NODE_ENV !== 'production'
    ? [createLogger()]
    : []
})
