'use strict';

var baseAnalysis = require('./analyse-parts/base');
var featuredAnalysis = require('./analyse-parts/featured');
var positionsAnalysis = require('./analyse-parts/positions');
var skillsAnalysis = require('./analyse-parts/skills');
var educationsAnalysis = require('./analyse-parts/educations');
var certificationsAnalysis = require('./analyse-parts/certifications');
var coursesAnalysis = require('./analyse-parts/courses');
var awardsAnalysis = require('./analyse-parts/awards');
var languagesAnalysis = require('./analyse-parts/languages');

class Profile {
  constructor($) {
    this.$ = $;
  }

  base() {
    return baseAnalysis(this.$, this);
  }

  featured() {
    return featuredAnalysis(this.$, this);
  }

  positions() {
    return positionsAnalysis(this.$, this);
  }

  skills() {
    return skillsAnalysis(this.$, this);
  }

  educations() {
    return educationsAnalysis(this.$, this);
  }

  certifications() {
    return certificationsAnalysis(this.$, this);
  }

  courses() {
    return coursesAnalysis(this.$, this);
  }

  awards() {
    return awardsAnalysis(this.$, this);
  }

  languages() {
    return languagesAnalysis(this.$, this);
  }

  clean() {
    delete this.$;
    return this;
  }

};

module.exports = Profile;
