<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>URL Shortener</title>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.10/css/dataTables.bootstrap.min.css">
</head>
<body>

    <div class="container">

        <div class="col-lg-10 col-lg-offset-1">
            <div class="page-header clearfix">
                <h1 class="text-muted">MBAStrategy Shortener</h1>
            </div>

            <div class="row">
                <div class="col-xs-12 col-md-8 col-lg-7">
                    <div class="well">
                        <form action="#">
                            <label for="long_url"><strong>Paste your long URL here:</strong></label>
                            <div class="input-group">
                                <input id="long_url" type="text"
                                    class="form-control" 
                                    placeholder="http(s)://..."
                                    tabindex="1"
                                    />

                                <span class="input-group-btn">
                                    <button type="submit" class="btn btn-default" id="shorten">Shorten URL</button>
                                </span>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-xs-12 col-md-4 col-lg-5">
                    <div id="short_url_block" class="well well-xs hide">
                        <label for="short_url"><strong>Copy to clipboard:</strong></label>
                        <div class="input-group">
                            <input id="short_url" type="text"
                                class="form-control" 
                                tabindex="2"
                                title="Press CTRL-C to copy"
                                data-toggle="tooltip"
                                data-placement="top"
                                data-trigger="focus"
                                onclick="$(this).select()"
                                />
                            <span class="input-group-btn">
                                <button id="remove_url" type="button"
                                    class="btn btn-default"
                                    title="Remove URL"
                                    data-toggle="tooltip"
                                    >
                                    <i class="glyphicon glyphicon-trash text-danger"></i>
                                </button>
                                <button id="copy_short_url" type="button"
                                    class="btn btn-default"
                                    title="Copy to clipboard"
                                    data-toggle="tooltip"
                                    data-clipboard-target="#short_url"
                                    >
                                    <i class="glyphicon glyphicon-copy"></i>
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <table class="table responsive no-wrap" width="100%">
                <thead>
                    <tr>
                        <th></th>
                        <th>LONG URL</th>
                        <th>CREATED</th>
                        <th>SHORT URL</th>
                        <th class="text-right">CLICKS</th>
                    </tr>
                </thead>
            </table>
        </div>
        
    </div>


    <script src="https://code.jquery.com/jquery-2.2.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js"></script>
    <script src="//cdn.datatables.net/1.10.10/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.10/js/dataTables.bootstrap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/1.5.5/clipboard.min.js"></script>

    <script>
    var SITE_PATH = location.host + location.pathname.replace('create.php', '');
    var SITE_URL = location.protocol + '//' + SITE_PATH;

    jQuery(function ($) {

        $('[data-toggle="tooltip"]').tooltip();

        new Clipboard('#copy_short_url');

        var table = $('table').DataTable({
            ajax: SITE_URL + 'index.php',
            responsive: true,
            ordering: false,
            columns: [
                { data: 'id' },
                { data: 'long_url' },
                { data: 'created' },
                { data: 'short_url' },
                { data: 'clicks' },
            ],
            columnDefs: [
                {
                    render: function (data, type, row) {
                        return [
                            '<input type="checkbox" class="show-url"',
                                ' data-id="', data, '" data-short-url="', row.short_url, '"', 
                            '>'
                        ].join('');
                    },
                    targets: 0
                },
                {
                    render: function (data, type, row) {
                        var text = data;

                        if (text.length > 40) {
                            text = text.toString().slice(0, 40) + '...';
                        }

                        return [
                            '<a href="', data, '" target="_blank">',
                                text,
                            '</a>'
                        ].join('');
                    },
                    targets: 1
                },
                {
                    render: function (data) {
                        var url = SITE_URL + data,
                            text = SITE_PATH + data;

                        return [
                            '<a href="', url, '" target="_blank">',
                                text,
                            '</a>'
                        ].join('');
                    },
                    targets: 3
                },
                {
                    className: 'text-right',
                    targets: 4
                }
            ]
        });

        $('#shorten').on('submit click', function (e) {
            e.preventDefault();

            var long_url = $('#long_url').val();

            $.ajax({
                type: 'POST',
                url: SITE_URL + 'index.php',
                data: {
                    long_url: long_url
                },
                dataType: 'json',
                success: function (data) {
                    if (data != false) {
                        table.ajax.reload();

                        show_short_url(data.id, data.short_url);
                    }
                }
            })
        });

        $('#remove_url').on('click', function (e) {
            e.preventDefault();

            var id = $(e.currentTarget).data('id');

            if (!id) return;

            $.ajax({
                type: 'POST',
                url: SITE_URL + 'index.php',
                data: {
                    id: id
                },
                success: function () {
                  table.ajax.reload();

                    $('#short_url_block').addClass('hide');
                }
            });
        });

        $('table').on('click', '.show-url', function (e) {
            var id = $(e.target).data('id'),
                url = $(e.target).data('short-url');

            show_short_url(id, url);
        });
    });

    function show_short_url(id, url) {
        $('#remove_url').data('id', id);
        $('#short_url_block').removeClass('hide');
        $('#short_url').val(SITE_URL + url)
            .select()
            .focus();
    }
    </script>
</body>
</html>